REM =======================================================
REM set TCP/IP server port for receiving NMEA GGA of rover
REM =======================================================
set GGA_IN_PORT=18000

REM =======================================================
REM set NTRIP user name (unique name per instance)
REM =======================================================
set NTRIP_USER=company1

REM =======================================================
REM set name of rover instance (4 characters max)
REM =======================================================
set NAME=SSRZ

REM =======================================================
REM NTRIP Caster (using SSRZ data from Laender-Instanz)
REM =======================================================
set CASTER_URL=caster.gepos.sapos.de
set CASTER_PORT=2101
set SSRZ_MOUNTPOINT=ZSS-SSRZ-BRST-DE
set EPH_MOUNTPOINT=ZSS-EPH-DE

REM =======================================================
REM datum transformation from ITRF to European Terrestrial
rem Reference Frame
REM =======================================================
set DAT_FILE=etrf_adv-itrf.dat
set ITRF=ITRF20
set ETRF=ETRF_R2025

REM =======================================================
REM run ssr2obs with needed options
REM =======================================================
start bin/ssr2obs +syst -n=%NAME% ^
-z=%CASTER_URL%:%CASTER_PORT% ^
-N=%SSRZ_MOUNTPOINT%,%NTRIP_USER%: ^
-eph=%CASTER_URL%:%CASTER_PORT% ^
-NE=%EPH_MOUNTPOINT%,%NTRIP_USER%: ^
-i=%GGA_IN_PORT% -o=- -rtcmmsm -atx_sv=igs20.atx ^
-re=0 -maxa=30 -dbcz=12 -II,ND=150 -TI,ND=150 ^
-datumdef=%DAT_FILE% -ssrdatum=%ITRF% -refdatum=%ETRF% 
